//Copyright (C)2002 Peter Mertens <peter@pmertens.de>.  
package de.pmertens;

//Klasse Kampagne startet Kampagnensteuerung
//unter Einsatz von DOM.
//Autor: Peter Mertens
//Version 1.0
public class Kampagne {
    
    private static boolean dokumentaktualisieren        = true;//Schalter XML-Dokument aktualisieren
    private static boolean zusaetzlicheElemente         = false;//zustzliche Personendaten erfassen
    
    private static boolean setvalidation                = true; //Grundstellungen
    private static boolean setnamespaces                = false;//Parser-Features
    private static boolean setschema                    = false;
    private static boolean setschemafullchecking        = false;
    private static boolean setdynamic                   = false;
    private static boolean setcontinueafterfatalerror   = false;
    private static boolean setdefernodeexpansion        = true;
    
    private static boolean ausgabehilfetext             = false;
    
    //Klassenmethode gibt Hilfetext aus
    public static void AusgabeHilfetext() {
        System.out.println("Anwendung: Kampagne [URI] (Optionen)");
        System.out.println();
        System.out.println(" -A / -a ein-/ausschalten Eingabe-XML-Dokument aktualisieren (Grundst. ein)");
        System.out.println(" -Z / -z ein-/ausschalten zustzliche Personendaten erfassen (Grundst. aus)");
        System.out.println();
        System.out.println("XML-Parseroptionen:");
        System.out.println(" -V / -v ein-/ausschalten Validation (Grundst. ein)");
        System.out.println(" -N / -n ein-/ausschalten Namespaces (Grundst. aus)");
        System.out.println(" -S / -s ein-/ausschalten Schema (Grundst. aus)");
        System.out.println(" -F / -f ein-/ausschalten Schemafullchecking (Grundst. aus)");
        System.out.println(" -D / -d ein-/ausschalten Dynamic (Grundst. aus)");
        System.out.println(" -C / -c ein-/ausschalten Continueafterfatalerror (Grundst. aus)");
        System.out.println(" -E / -e ein-/ausschalten Defernodeexpansion (Grundst. ein)");
        System.out.println();
        System.out.println(" -h / -H / -? Ausgabe dieser Hilfestellung");
        System.out.println();
    }
        
    //Main-Methode startet XML-Verarbeitung
    public static void main(String[] args) {
        if (args.length == 0) {
            AusgabeHilfetext();
            System.exit(1);
        }
        
        System.out.println("Copyright (C)2002 Peter Mertens <peter@pmertens.de>");
        System.out.print("Programm Kampagne aufgerufen mit Parametern");

        //Parameterprfung
        for ( int i = 0; i < args.length; i++ ) {
           String arg = args[i];
           System.out.print(" " + arg);

           //Optionsschalter
           if ( arg.startsWith("-") ) {
              switch (arg.charAt(1)) {
                  case 'a': {
                      dokumentaktualisieren= false;
                      break;
                  }
                  case 'A': {
                      dokumentaktualisieren= true;
                      break;
                  }
                  
                  case 'z': {
                      zusaetzlicheElemente= false;
                      break;
                  }
                  case 'Z': {
                      zusaetzlicheElemente= true;
                      break;
                  }
                  
                  case 'v': {
                      setvalidation= false;
                      break;
                  }
                  case 'V': {
                      setvalidation= true;
                      break;
                  }
                  
                  case 'n': {
                      setnamespaces= false;
                      break;
                  }
                  case 'N': {
                      setnamespaces= true;
                      break;
                  }
                  
                  case 's': {
                      setschema= false;
                      break;
                  }
                  case 'S': {
                      setschema= true;
                      break;
                  }
                  
                  case 'f': {
                      setschemafullchecking= false;
                      break;
                  }
                  case 'F': {
                      setschemafullchecking= true;
                      break;
                  }
                  
                  case 'd': {
                      setdynamic= false;
                      break;
                  }
                  case 'D': {
                      setdynamic= true;
                      break;
                  }
                  
                  case 'c': {
                      setcontinueafterfatalerror= false;
                      break;
                  }
                  case 'C': {
                      setcontinueafterfatalerror= true;
                      break;
                  }
                  
                  case 'e': {
                      setdefernodeexpansion= false;
                      break;
                  }
                  case 'E': {
                      setdefernodeexpansion= true;
                      break;
                  }
                  
                  case 'h':
                  case 'H':
                  case '?': {
                      ausgabehilfetext= true;
                  }
              }
           }
        }
        System.out.println();
        
        if (ausgabehilfetext)
            AusgabeHilfetext();

        //de.pmertens.DOMKampagne parser= new de.pmertens.DOMKampagne();
        DOMKampagne parser= new DOMKampagne();
        
        parser.DOMStart(args[0], setvalidation, setnamespaces, setschema, setschemafullchecking,
            setdynamic, setcontinueafterfatalerror, setdefernodeexpansion, dokumentaktualisieren,
            zusaetzlicheElemente);
    }
}